//@include "./resources.jsx"


/**
 * Writes the embedded "binary" project to the userData folder and loads it
 * The write path is dependant on the Folder property `userData` so differs on each platform
 * * Windows    - `C:\\users\{USER}\AppData\Roaming\Benchmark.aep` or `%APPDATA%\Benchmark.aep`
 * * MacOS      - `~/Library/Application Support/Benchmark.aep`
 */
function loadProject()
{
    // Creating a new File object with the appropriate path
    var projectFile = new File(Folder.userData.fsName + "/Benchmark.aep");
    
    projectFile.open("w");                      // "w" tells AE to create a new file if one doesn't exist
    projectFile.encoding = "BINARY";            // Allow us to write binary data to the file
    projectFile.write(RESOURCES.aeProject);     // Write the project embedded code to the file
    projectFile.close();                        // Close the file
    

    // BoilerPlate: Checking to make sure the file exists, if not something went wrong
    if(!projectFile.exists) {
        throw "The project file did not write correctly, something went wrong."
    }

    // We stop errors from appearing here because AE will tell the user that it wants to convert 
    //  the file to a new version, we want this, but it's unnecessary for the user to know
    app.beginSuppressDialogs();

    app.open(projectFile);                      // Now tell AE to open the project
    app.project.save(projectFile);              // Save the converted version to prevent alerts

    // Stop supressing Dialogs, the "false" tells AE not to display all the supressed alerts
    app.endSuppressDialogs(false);

    // And finally return the projectFile as this will need to be deleted later
    return projectFile;
}
